<h1 align="center">
  <img alt="FeedGet" src=".github/preview.png" width="100%">
</h1>
<br>
<p align="center">
  <a href="#-projeto">Projeto</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;
  <a href="#-tecnologias">Tecnologias</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;
  <a href="#-features">Features</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;
  <a href="#-layout">Layout</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;
  <a href="#-executando-o-projeto">Executando o projeto</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;
  <a href="#memo-licença">Licença</a>
</p>

<br>



<p align="center">
  <img src="https://img.shields.io/website?down_message=offline&logo=vercel&style=for-the-badge&up_message=online&url=https%3A%2F%2Fcapstone-group2-alex-eight.vercel.app%2F&labelColor=3d1b8c&logoColor=black" alt="Server Status">
  <img src="https://img.shields.io/github/last-commit/imthedaniel/five-bets?style=for-the-badge&color=a47dfd&labelColor=3d1b8c" alt="Languages">
  <img src="https://img.shields.io/github/languages/count/imthedaniel/five-bets?style=for-the-badge&color=a47dfd&labelColor=3d1b8c" alt="Languages">
  <img src="https://img.shields.io/github/license/imthedaniel/five-bets?style=for-the-badge&labelColor=3d1b8c&color=a47dfd" alt="Licenses" />
</p>

<p align="center">
  <a href="https://capstone-group2-alex-eight.vercel.app/">Clique aqui</a> para acessar a versão web
</p>

## ✨ Projeto

Five Bet é um site de apostas completo! Como visitante você pode visualizar jogos acontecendo em tempo real, após criar sua conta você terá um dashboard para realizar apostas, efetuar saques ou depósitos, alteração de senha ou foto de perfil e também pode consultar históricos de transações, apostas e afiliados. O projeto está com dados fictícios pois a API paga tem um limite pequeno de requisições, mas está todo desenvolvido para receber uma chave de API e obter dados em tempo real, como a adição de novos esportes para apostas.

Vale destacar que este projeto utiliza além da API de jogos em tempo real, uma segunda API que armazena todos os dados dos usuários (Cadastros, Apostas, Históricos...), esta segunda API foi desenvolvida do zero. Tornando-se assim um projeto que foi feito além do front, também seu back-end.

## 🚀 Tecnologias

Esse projeto foi desenvolvido com as seguintes tecnologias/bibliotecas:

<table border="0">
 <tr>
<td> HTML5</td>
<td> CSS3</td>
<td> JavaScript</td>
<td> MaterialUI</td>
<td> Referral Codes</td>
 </tr>
  <tr>
<td> Axios</td>
<td> Framer Motion</td>
<td> Phosphor Icons</td>
<td> Yup</td>
<td> Styled Components</td>
 </tr>
  <tr>
<td> React</td>
<td> React Timestamp</td>
<td> React Toastify</td>
<td> React Router Dom</td>
<td> React Hook Form</td>
 </tr>
</table>

## 🌟 Features

-   [ ] 100% responsivo em resoluções até 4k.
-   [ ] Página de contato com formulário de mensagens.
-   [ ] Estatísticas dinâmicas em todo o site.
-   [ ] Cadastro e Login com validações e código de afiliado.
-   [ ] Sistema de Afiliado completo oferecendo recompensas e histórico.
-   [ ] Histórico de transações, afiliações e apostas.
-   [ ] Alteração de Senha ou Foto de Perfil
-   [ ] Sistema complexo de apostas (Automaticamente os jogos encerrados disparam um evento que detecta os possíveis ganhadores, para que eles recebam suas recompensas ou não. Após isso efetua o preenchimento de todo histórico e estatísticas no site).

## 🎨 Layout

 Este projeto não foi desenvolvido a partir de um figma.

## 👨🏻‍💻 Executando o projeto

Utilize o **yarn** ou o **npm install** para instalar as dependências do projeto.
Em seguida, inicie o projeto.

Iniciando a versão web:

```cl
yarn start ou npm run dev
```

## :memo: Licença

Esse projeto está sob a licença MIT. Veja o arquivo [LICENSE](./LICENSE.md) para mais detalhes.

---
